package ai.guiji.duix.sample.util;

import android.util.Log;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;


public class HttpUtils {

    private static final String TAG = "HttpUtils";

    public static class HttpResult {
        public int code;
        public String body;

        public HttpResult(int code, String body) {
            this.code = code;
            this.body = body;
        }
    }

    public static HttpResult uploadFile(String filePath) {
        try {
            String baseUrl = "https://robot.guiji.ai/aibase/call/20131";
            File file = new File(filePath);
            //新建url对象
            URL url = new URL(baseUrl);
            //通过HttpURLConnection对象,向网络地址发送请求
            HttpURLConnection urlConn = (HttpURLConnection) url.openConnection();
            //设置该连接允许读取
            urlConn.setDoOutput(true);
            //设置该连接允许写入
            urlConn.setDoInput(true);
            //设置不能适用缓存
            urlConn.setUseCaches(false);
            //设置连接超时时间
            urlConn.setConnectTimeout(30 * 1000);   //设置连接超时时间
            //设置读取超时时间
            urlConn.setReadTimeout(30 * 1000);   //读取超时
            //设置连接方法post
            urlConn.setRequestMethod("POST");
//            //设置维持长连接
//            urlConn.setRequestProperty("connection", "Keep-Alive");
//            //设置文件字符集
//            urlConn.setRequestProperty("Accept-Charset", "UTF-8");
            //设置文件类型
            urlConn.setRequestProperty("Content-Type", "audio/wave;charset=UTF-8");

            OutputStream outStream = urlConn.getOutputStream();
            int bytesRead;
            byte[] buffer = new byte[1024];
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            while ((bytesRead = in.read(buffer)) != -1) {
                outStream.write(buffer, 0, bytesRead);
            }
            outStream.flush();
            outStream.close();
            int statusCode = urlConn.getResponseCode();
            if (statusCode == 200) {
                // 获取返回的数据
                String result = streamToString(urlConn.getInputStream());
                return new HttpResult(0, result);
            } else {
                return new HttpResult(-1, "上传失败");
            }
        } catch (IOException e) {
            return new HttpResult(-1, e.toString());
        }
    }

    /**
     * 将输入流转换成字符串
     *
     * @param is 从网络获取的输入流
     * @return
     */
    public static String streamToString(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int len;
            while ((len = is.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            baos.close();
            is.close();
            byte[] byteArray = baos.toByteArray();
            return new String(byteArray);
        } catch (Exception e) {
            Log.e(TAG, e.toString());
            return null;
        }
    }
}
