package ai.guiji.duix.sample.ui.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.widget.SwitchCompat;

import ai.guiji.duix.sample.App;
import ai.guiji.duix.sample.Constant;
import ai.guiji.duix.sample.R;
import ai.guiji.duix.sample.network.INetworkCallback;
import ai.guiji.duix.sample.network.NetworkResultInfo;
import ai.guiji.duix.sample.network.TokenRequest;
import ai.guiji.duix.sample.pojo.DUIXConfig;
import ai.guiji.duix.sample.ui.activity.base.BaseActivity;
import ai.guiji.duix.sample.util.DeviceUtils;
import ai.guiji.duix.sdk.BuildConfig;

public class MainActivity extends BaseActivity implements View.OnClickListener, AdapterView.OnItemSelectedListener, INetworkCallback {

    TextView tv_version, tv_clean_cache;
    EditText et_port, et_app_id, et_user_jid, et_host, et_group_id;
    SwitchCompat switch_camera, switch_asr, switch_debug, switch_control_panel;
    Spinner spinner_bot_mode, spinner_group_id, spinner_asr_mode, spinner_host;
    ArrayAdapter<String> modeAdapter, groupAdapter, asrAdapter, hostAdapter;
    private final String[] hostArray = {"vshow.guiji.ai", "new.guiji.ai"};
    private final String[] modeArray = {"Client driver", "BOT driver"};
    private final String[] groupArray = {"duix-public", "dhrtcpc"};
    private final String[] asrArray = {"SpeechRecognizer", "SpeechTranscriber"};

    DUIXConfig mConfig;

    TokenRequest mTokenRequest;                 // 网络请求token

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        tv_version = findViewById(R.id.tv_version);
        tv_version.setText(getString(R.string.app_version, DeviceUtils.getVersionName(mContext), BuildConfig.VERSION_NAME));
        tv_clean_cache = findViewById(R.id.tv_clean_cache);
        tv_clean_cache.setOnClickListener(this);
        findViewById(R.id.btn_display).setOnClickListener(this);
        findViewById(R.id.tv_clean_cache).setOnClickListener(this);
        et_port = findViewById(R.id.et_port);
        et_app_id = findViewById(R.id.et_app_id);
        et_user_jid = findViewById(R.id.et_user_jid);
        et_host = findViewById(R.id.et_host);
        et_group_id = findViewById(R.id.et_group_id);

        switch_camera = findViewById(R.id.switch_camera);
        switch_asr = findViewById(R.id.switch_asr);
        switch_debug = findViewById(R.id.switch_debug);
        switch_control_panel = findViewById(R.id.switch_control_panel);

        spinner_host = findViewById(R.id.spinner_host);
        hostAdapter = new ArrayAdapter<>(this, R.layout.layout_bot_spinner_select, hostArray);
        hostAdapter.setDropDownViewResource(R.layout.layout_bot_spinner_drap);
        spinner_host.setAdapter(hostAdapter);
        spinner_host.setOnItemSelectedListener(this);
        spinner_host.setSelection(0);

        spinner_bot_mode = findViewById(R.id.spinner_bot_mode);
        modeAdapter = new ArrayAdapter<>(this, R.layout.layout_bot_spinner_select, modeArray);
        modeAdapter.setDropDownViewResource(R.layout.layout_bot_spinner_drap);
        spinner_bot_mode.setAdapter(modeAdapter);
        spinner_bot_mode.setOnItemSelectedListener(this);
        spinner_bot_mode.setSelection(1);

        spinner_group_id = findViewById(R.id.spinner_group_id);
        groupAdapter = new ArrayAdapter<>(this, R.layout.layout_bot_spinner_select, groupArray);
        groupAdapter.setDropDownViewResource(R.layout.layout_bot_spinner_drap);
        spinner_group_id.setAdapter(groupAdapter);
        spinner_group_id.setOnItemSelectedListener(this);
        spinner_group_id.setSelection(0);

        spinner_asr_mode = findViewById(R.id.spinner_asr_mode);
        asrAdapter = new ArrayAdapter<>(this, R.layout.layout_bot_spinner_select, asrArray);
        asrAdapter.setDropDownViewResource(R.layout.layout_bot_spinner_drap);
        spinner_asr_mode.setAdapter(asrAdapter);
        spinner_asr_mode.setOnItemSelectedListener(this);
        spinner_asr_mode.setSelection(1);

        mConfig = DUIXConfig.read(mContext);

        mTokenRequest = new TokenRequest(mContext, App.mApp.mQueue, this);

        initUI();
    }

    private void initUI() {
        et_host.setText(mConfig.getHost());
        et_port.setText(String.valueOf(mConfig.getPort()));
        et_app_id.setText(mConfig.getAppId());
        et_user_jid.setText(mConfig.getJID());
        spinner_bot_mode.setSelection("".equals(mConfig.getRobotMode()) ? 0 : 1);
        et_group_id.setText(mConfig.getGroupId());
        spinner_asr_mode.setSelection(mConfig.getAsrMode());
        switch_asr.setChecked(mConfig.isAsr());
        switch_camera.setChecked(mConfig.isCamera());
        switch_debug.setChecked(mConfig.isDebug());
        switch_control_panel.setChecked(mConfig.isControlPanel());
    }


    @Override
    public void onClick(View v) {
        int id = v.getId();
        if (id == R.id.btn_display) {
            // save config
            mConfig.setHost(et_host.getText().toString());
            mConfig.setPort(Integer.parseInt(et_port.getText().toString()));
            mConfig.setAppId(et_app_id.getText().toString());
            mConfig.setJID(et_user_jid.getText().toString());
            mConfig.setRobotMode(spinner_bot_mode.getSelectedItemPosition() == 0 ? "" : "bot");
            mConfig.setGroupId(et_group_id.getText().toString());
            mConfig.setAsrMode(spinner_asr_mode.getSelectedItemPosition());
            mConfig.setAsr(switch_asr.isChecked());
            mConfig.setCamera(switch_camera.isChecked());
            mConfig.setDebug(switch_debug.isChecked());
            mConfig.setControlPanel(switch_control_panel.isChecked());
            mConfig.save(mContext);

            // 请求token
            showLoadingDialog();
            mTokenRequest.getSig(et_app_id.getText().toString());

//            Intent display = new Intent(mContext, DisplayActivity.class);
//            display.putExtra("config", mConfig);
//            startActivity(display);
        } else if (id == R.id.tv_clean_cache) {
            DUIXConfig.clear(mContext);
            Toast.makeText(mContext, R.string.cache_record_cleaned, Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
        if (parent == spinner_host) {
            et_host.setText(hostAdapter.getItem(position));
            // 测试: 241583310181109760  生产: 245982983437047536
            et_app_id.setText(position == 0 ? "1501842413046599680" : "1498638678543699968");
        } else if (parent == spinner_group_id) {
            et_group_id.setText(groupAdapter.getItem(position));
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {

    }

    @Override
    public void onNetworkResult(int requestId, NetworkResultInfo info) {
        if (requestId == Constant.API_REQUEST_ID.GET_SIG.ordinal()) {
            String data = (String) info.data;
            mTokenRequest.checkSig(data);
        } else if (requestId == Constant.API_REQUEST_ID.CHECK_SIG.ordinal()) {
            String token = (String) info.data;
            runOnUiThread(() -> {
                mConfig.setToken(token);
                Intent display = new Intent(mContext, DisplayActivity.class);
                display.putExtra("config", mConfig);
                startActivity(display);

                dismissLoadingDialog();
            });
        }
    }

    @Override
    public void onNetworkError(int requestId, NetworkResultInfo info) {
        runOnUiThread(() -> {
            if (isFinishing()) return;
            dismissLoadingDialog();
            if (info.data instanceof String) {
                Toast.makeText(mContext, (String) info.data, Toast.LENGTH_SHORT).show();
            }
        });
    }
}