package ai.guiji.duix.sample.pojo;

import android.content.Context;
import android.content.SharedPreferences;

public class LastSessionInfo {

    public String appId;
    public String flowId;
    public String nodeId;


    private static final String SP_KEY = "rtc_data";

    public static void put(Context context, String appId, String flowId, String nodeId) {
        SharedPreferences preferences = context.getSharedPreferences(SP_KEY, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        if (editor != null) {
            editor.putString("appId", appId);
            editor.putString("flowId", flowId);
            editor.putString("nodeId", nodeId);
            editor.apply();
        }
    }

    public static void clear(Context context) {
        put(context, "", "", "");
    }

    public static LastSessionInfo get(Context context) {
        LastSessionInfo lastSessionInfo = new LastSessionInfo();
        SharedPreferences preferences = context.getSharedPreferences(SP_KEY, Context.MODE_PRIVATE);
        lastSessionInfo.appId = preferences.getString("appId", "");
        lastSessionInfo.flowId = preferences.getString("flowId", "");
        lastSessionInfo.nodeId = preferences.getString("nodeId", "");
        return lastSessionInfo;
    }


    @Override
    public String toString() {
        return "LastSessionInfo{" +
                "robotCode='" + appId + '\'' +
                ", flowId='" + flowId + '\'' +
                ", nodeId='" + nodeId + '\'' +
                '}';
    }
}
