package ai.guiji.duix.sample.pojo;

import android.content.Context;
import android.content.SharedPreferences;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;

/**
 * DUIX配置信息，用于持久化和快速恢复到上次配置
 */
public class DUIXConfig implements Serializable {

    public static final String SP_FILE = "sp_duix";
    public static final String KEY = "duix_config_v2";


    String host;
    int port;
    String appId;
    String robotMode;   // "", "bot"
    String groupId;
    String JID;
    int asrMode;    // 0: 一句话， 1: 长连接。 一句话的时候不要打开媒体通道，将audio资源留下来手动发起
    boolean asr;
    boolean camera;
    boolean debug;
    boolean controlPanel;

    String token;

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getRobotMode() {
        return robotMode;
    }

    public void setRobotMode(String robotMode) {
        this.robotMode = robotMode;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getJID() {
        return JID;
    }

    public void setJID(String JID) {
        this.JID = JID;
    }

    public int getAsrMode() {
        return asrMode;
    }

    public void setAsrMode(int asrMode) {
        this.asrMode = asrMode;
    }

    public boolean isAsr() {
        return asr;
    }

    public void setAsr(boolean asr) {
        this.asr = asr;
    }

    public boolean isCamera() {
        return camera;
    }

    public void setCamera(boolean camera) {
        this.camera = camera;
    }

    public boolean isDebug() {
        return debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isControlPanel() {
        return controlPanel;
    }

    public void setControlPanel(boolean controlPanel) {
        this.controlPanel = controlPanel;
    }

    private static DUIXConfig getDefault() {
        DUIXConfig config = new DUIXConfig();
        config.host = "vshow.guiji.ai";
        config.port = 5222;
        config.appId = "1501842413046599680";    // 245982983437047536
        config.robotMode = "bot";
        config.groupId = "duix-public";
        config.JID = "iray-proxy-duix@guiji.ai";
        config.asrMode = 1;
        config.asr = true;
        config.camera = true;
        config.debug = true;
        config.controlPanel = true;
        return config;
    }

    public static DUIXConfig read(Context context) {
        DUIXConfig config;
        SharedPreferences preferences = context.getSharedPreferences(SP_FILE, Context.MODE_PRIVATE);
        String spInfo = preferences.getString(KEY, "");
        if ("".equals(spInfo)) {
            config = DUIXConfig.getDefault();
        } else {
            config = new DUIXConfig();
            try {
                JSONObject jsonObject = new JSONObject(spInfo);
                config.host = jsonObject.optString("host");
                config.port = jsonObject.optInt("port");
                config.appId = jsonObject.optString("appId");
                config.robotMode = jsonObject.optString("robotMode");
                config.groupId = jsonObject.optString("groupId");
                config.JID = jsonObject.optString("JID");
                config.asrMode = jsonObject.optInt("asrMode");
                config.asr = jsonObject.optBoolean("asr");
                config.camera = jsonObject.optBoolean("camera");
                config.debug = jsonObject.optBoolean("debug");
                config.controlPanel = jsonObject.optBoolean("controlPanel");
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return config;
    }

    public static void clear(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SP_FILE, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(KEY, "");
        editor.apply();
    }

    public void save(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(SP_FILE, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        if (editor != null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("host", this.host);
                jsonObject.put("port", this.port);
                jsonObject.put("appId", this.appId);
                jsonObject.put("robotMode", this.robotMode);
                jsonObject.put("groupId", this.groupId);
                jsonObject.put("JID", this.JID);
                jsonObject.put("asrMode", this.asrMode);
                jsonObject.put("asr", this.asr);
                jsonObject.put("camera", this.camera);
                jsonObject.put("debug", this.debug);
                jsonObject.put("controlPanel", this.controlPanel);
            } catch (JSONException e) {
                e.printStackTrace();
            }
            editor.putString(KEY, jsonObject.toString());
            editor.apply();
        }
    }

    @Override
    public String toString() {
        return "DUIXConfig{" +
                "host='" + host + '\'' +
                ", port=" + port +
                ", appId='" + appId + '\'' +
                ", robotMode='" + robotMode + '\'' +
                ", groupId='" + groupId + '\'' +
                ", JID='" + JID + '\'' +
                ", asrMode=" + asrMode +
                ", asr=" + asr +
                ", camera=" + camera +
                ", debug=" + debug +
                ", controlPanel=" + controlPanel +
                '}';
    }
}
