package ai.guiji.duix.sample.network;

import android.content.Context;
import android.util.Log;

import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;

import ai.guiji.duix.sample.Constant;
import ai.guiji.duix.sample.R;


public class BaseRequest {

    protected String TAG = getClass().getSimpleName();

    Context mContext;
    RequestQueue mQueue;
    INetworkCallback callback;

    public BaseRequest(Context context, RequestQueue queue, INetworkCallback callback) {
        this.mContext = context;
        this.mQueue = queue;
        this.callback = callback;
    }


    class VolleyRequestError implements Response.ErrorListener {

        int requestId;

        VolleyRequestError(int requestId) {
            this.requestId = requestId;
        }

        @Override
        public void onErrorResponse(VolleyError error) {
            if (callback != null) {
//                callback.onNetworkError(requestId, );
                Log.e(TAG, "VolleyRequestError: " + error);
                onError(requestId, Constant.RESULT_CODE_REQUEST_ERROR, mContext.getString(R.string.connect_server_error));
            }
        }
    }

    protected void onResult(int requestId, Object data) {
        callback.onNetworkResult(requestId, new NetworkResultInfo(Constant.RESULT_CODE_SUCCESS, data));
    }

    private void onError(int requestId, int resultCode, String msg) {
        callback.onNetworkError(requestId, new NetworkResultInfo(resultCode, msg));
    }

    protected void onJsonParseError(int requestId) {
        onError(requestId, Constant.RESULT_CODE_PARSE_ERROR, mContext.getString(R.string.parse_error));
    }

    protected void onResultError(int requestId, String msg) {
        onError(requestId, Constant.RESULT_CODE_RESULT_ERROR, msg);
    }
}
