package ai.guiji.duix.sample.ui.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;

import ai.guiji.duix.sample.R;


public class LoadingDialog extends Dialog {

    int contentId;
    Context mContext;

    public LoadingDialog(@NonNull Context context) {
        super(context, R.style.dialog_center);
        contentId = R.string.loading;
        mContext = context;
    }

    public LoadingDialog(@NonNull Context context, int contentId) {
        super(context, R.style.dialog_center);
        this.contentId = contentId;
        mContext = context;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        View contentView = getLayoutInflater().inflate(R.layout.dialog_loading, null);
        setContentView(contentView);
        TextView tv_loading = contentView.findViewById(R.id.tv_loading);
        tv_loading.setText(contentId);
        ImageView iv_loading = contentView.findViewById(R.id.iv_loading);
        Animation anim = AnimationUtils.loadAnimation(mContext, R.anim.center_rotate_anim);
        anim.setInterpolator(new LinearInterpolator());
        iv_loading.startAnimation(anim);

        setCancelable(true);
        setCanceledOnTouchOutside(false);
    }


}
