package ai.guiji.duix.sample.ui.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

import ai.guiji.duix.sample.R;


public class WavUrlAdapter extends RecyclerView.Adapter<WavUrlAdapter.ViewHolder> {

    private final List<WavInfo> mWavList = new ArrayList<>();
    private final LayoutInflater mLayoutInflater;
    private final Context mContext;
    private WavClickListener mClickListener;

    public WavUrlAdapter(Context context, List<WavInfo> list, WavClickListener listener) {
        this.mContext = context;
        mLayoutInflater = LayoutInflater.from(mContext);
        mWavList.clear();
        mWavList.addAll(list);
        mClickListener = listener;
    }

    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewHolder(mLayoutInflater.inflate(R.layout.item_wav_url, parent, false));
    }

    @SuppressLint("SetTextI18n")
    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, @SuppressLint("RecyclerView") int position) {
        WavInfo bean = mWavList.get(position);
        //时间
        holder.tv_name.setText(bean.name);

        //根布局点击
        holder.tv_name.setOnClickListener(v -> {
            if (null != mClickListener) {
                mClickListener.wavClick(bean.url);
            }
        });
    }

    @Override
    public int getItemCount() {
        return mWavList.size();
    }

    static class ViewHolder extends RecyclerView.ViewHolder {
        TextView tv_name;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            tv_name = itemView.findViewById(R.id.tv_name);
        }
    }

    public interface WavClickListener {
        void wavClick(String url);
    }


    public static class WavInfo {
        public String name;
        public String url;

        public WavInfo(String name, String url) {
            this.name = name;
            this.url = url;
        }
    }
}
